/*-----------------------------------------------------------------------------------------------------------------------------
FileName: smallBuffer.h 
Autor:  Mathieu Gisselbrecht
Date : Creation -  Avril 2006
-----------------------------------------------------------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------------------------------------------------------
// MISC #DEFINEs
//-----------------------------------------------------------------------------------------------------------------------------
#define BUFFER_SIZE 	1000000
#define MAX_MASK		5

//-----------------------------------------------------------------------------------------------------------------------------
// TYPEDEF AND STRUCTURE 
//-----------------------------------------------------------------------------------------------------------------------------
typedef struct SBuffer {
	int  type;							// Access Type 8, 16, 24, 32 bits access
	void *ptrBegin, *ptrEnd;			// Pointer to the begining and to the end of the data
	void *endofBuffer;
	long mask[MAX_MASK];				// Mask to access to the data
	char data[BUFFER_SIZE+4];			// Raw data
	} TBuffer;

//-----------------------------------------------------------------------------------------------------------------------------
// GLOBAL PROTOTYPES 
//-----------------------------------------------------------------------------------------------------------------------------
void createBuffer(TBuffer *buffer, int type);
void resetBuffer(TBuffer *buffer);
int readBuffer(TBuffer *buffer, int type, long *data);
int writeBuffer(TBuffer *buffer, int type, long data);
int ismarkerBuffer(unsigned char marker, TBuffer *buffer,int ntimes, int bits);
float freespaceBuffer(TBuffer *buffer);